/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS BCD DECADE COUNTER 
TRUTHTABLE     : 

+---------------------------------------+-----------------------+
|              INPUT                    |                       |
+---------------------------------------+       OPERATION       |
|     CLR_     LOAD_  ENT   ENP    CLK  |                       |
+---------------------------------------+-----------------------+
|      L        X     X     X      X    |   Asynchronous Clear  | 
|                                   _   |                       |
|      H        L     X     X     _/    |   Load Parrallel Data |
|                                   _   |                       |
|      H        H     H     H     _/    |   Decade Counter      |
|                                       |                       |
|      H        H     L     X      X    |   Inhibit Counting    |
|                                       |                       |
|      H        H     X     L      X    |   Inhibit Counting    |
+---------------------------------------+-----------------------+ 


Note : RCO goes high at the terminal count for the duration 
       of one clock pulse.


REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a160 (clrn, clk, a, b, c, d, enp, ldn, ent, qd, qc, qb, qa, rco);
	parameter size =1;
	input
		clrn,
		ldn,
		enp,
		ent,
		clk,
		a,
		b,
		c,
		d;
	output
		qa,
		qb,
		qc,
		qd,
		rco;
    reg
        NOTIFY_REG;
    not
	N1 (pe, ldn);
    and
	A1 (en1, pe, clrn);
    and
	A2 (en2, ldn, clrn, ent);
    and
	A3 (en3, ldn, clrn, enp);
    not
	M160_inst_I1 (m160_inst_wi1, ldn);
    and
	M160_inst_A1 (m160_inst_wa1, enp, ent, ldn);
    and  
	M160_inst_A2 (rco, dd_net_42, m160_inst_qaint, m160_inst_qdint);
    and
	M160_inst_A3 (m160_inst_wa3, ldn, m160_inst_qaint);
    and
	M160_inst_A7 (m160_inst_wa7, m160_inst_wna1, ldn, m160_inst_qbint);
    and
	M160_inst_A8 (m160_inst_wa8, m160_inst_wna2, m160_inst_wa1, m160_inst_qaint, m160_inst_wqb4);
    and
	M160_inst_A9 (m160_inst_wa9, m160_inst_wi1, b);
    and
	M160_inst_A11 (m160_inst_wa11, m160_inst_wna3, ldn, m160_inst_qdint);
    and
	M160_inst_A12 (m160_inst_wa12, m160_inst_wna4, m160_inst_wa1, m160_inst_qcint, m160_inst_qbint, m160_inst_qaint);
    and
	M160_inst_A13 (m160_inst_wa13, m160_inst_wi1, d);
    nand
	M160_inst_NA1 (m160_inst_wna1, m160_inst_wa1, m160_inst_qaint);
    nand
	M160_inst_NA2 (m160_inst_wna2, ldn, m160_inst_qbint);
    nand
	M160_inst_NA3 (m160_inst_wna3, m160_inst_wa1, m160_inst_qaint);
    nand
	M160_inst_NA4 (m160_inst_wna4, ldn, m160_inst_qdint);
    xor
	M160_inst_XO1 (m160_inst_wxo1, m160_inst_wa3, m160_inst_wa1);
    or
	M160_inst_O2 (m160_inst_wo2, m160_inst_wa7, m160_inst_wa8, m160_inst_wa9);
    or
	M160_inst_O4 (m160_inst_wo4, m160_inst_wa11, m160_inst_wa12, m160_inst_wa13);
    not
	M160_inst_N1 (m160_inst_wqb4, m160_inst_qdint);
    buf  
	  (qa, m160_inst_qaint);
    buf
	  (qb, m160_inst_qbint);
    buf  
	  (qc, m160_inst_qcint);
    buf  
	  (qd, m160_inst_qdint);
    U_AO_3
	M160_inst_inst1_inst1 (m160_inst_wo1, m160_inst_wxo1, m160_inst_wi1, a);
    U_AXO_2_3
	M160_inst_inst2_inst1 (m160_inst_wxo2, ldn, m160_inst_qcint, m160_inst_wa1, m160_inst_qaint, m160_inst_qbint);
    U_AO_3
	M160_inst_inst3_inst1 (m160_inst_wo3, m160_inst_wxo2, m160_inst_wi1, c);
    U_FD_P_RB_NO  
	M160_inst_DFF1_inst1 (m160_inst_qaint, m160_inst_wo1, clk, dd_net_34, NOTIFY_REG);
    U_FD_P_RB_NO  
	M160_inst_DFF2_inst1 (m160_inst_qbint, m160_inst_wo2, clk, dd_net_34, NOTIFY_REG);
    U_FD_P_RB_NO
	M160_inst_DFF3_inst1 (m160_inst_qcint, m160_inst_wo3, clk, dd_net_34, NOTIFY_REG);
    U_FD_P_RB_NO  
	M160_inst_DFF4_inst1 (m160_inst_qdint, m160_inst_wo4, clk, dd_net_34, NOTIFY_REG);
    buf  
	  (dd_net_34, clrn);
    buf  
	  (dd_net_42, ent);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
